﻿/* Copyright 2019, Kasyan Servetsky
December 10, 2019
Written by Kasyan Servetsky
http://www.kasyan.ho.com.ua
e-mail: askoldich@yahoo.com */
//======================================================================================
var scriptName = "Find-replace",
doc,
debugMode = false, // for debugging only
count = 0;

app.doScript(PreCheck, ScriptLanguage.JAVASCRIPT, undefined, UndoModes.ENTIRE_SCRIPT, "\"" + scriptName + "\" script");
//===================================== FUNCTIONS ======================================
function Main() {
	try {
		var changed, a, el,
		startTime = new Date(),
		logArr = [];
		
		logArr.push("=========================================================\rDate & time: " + GetDate() + "\r");

		with (app.findChangeTextOptions) {
			caseSensitive = true;
			wholeWord = true;
			includeHiddenLayers = true;
			includeLockedLayersForFind = true;
			includeLockedStoriesForFind = true;
			includeMasterPages = false;
		}
	
		with (app.findChangeGrepOptions) {
			includeHiddenLayers = true;
			includeLockedLayersForFind = true;
			includeLockedStoriesForFind = true;
			includeMasterPages = false;
		}
	
		//======================================================================================
		// Additional
		// This is just different little things, mostly headers of the table columns, and so on.
		
		// GREP ["findWhat", "changeTo", false],
		// TEXT ["findWhat", "changeTo", true, null, null, null],
		
		// Examples:
		// ["Cena", "<<cena>>", true, "caseSensitive:true", null, "appliedParagraphStyle:doc.paragraphStyles.item('Header')"],
		// ["Cena", "<<cena>>", true, "caseSensitive:true", null, "appliedParagraphStyle:doc.paragraphStyleGroups.item('My headers').paragraphStyles.item('Header')"],
		
		// NOTE: ["Granulacja", "<<gran>>", true, null, null, null] is the same as ["Granulacja", "<<gran>>"]
		// if only two elements in a sub-array, TEXT search is performed by default
		
		// Parameters:
		// 1 — findWhat (required)
		// 2 — changeTo (required)
		// 3 — text [text=true , or if missing by default | grep=false] (optional)
		// 4 — findChangeText/GrepOptions (optional)
		// 5 — findText/GrepPreferences (optional)
		// 6 — changeText/GrepPreferences (optional)
		//======================================================================================
		a = [
				["(?i)Nr\\.\\s*kat\\.", "<nr_kat>", false], // case-insensitive, with(out) a space in between 
				["Na elektronarzędzia i urządzenia marki", "<<na_elektro>>", true, null, null, "pointSize:10"], 
				["Granulacja", "<<gran>>", true, null, null, null],
				["(?i)Cena\\s*?promo", "<<cena_pro>>", false], // case-insensitive, one or more spaces in between. Words 'Cena' and 'promo' may have any number of spaces in between (the shortest match). (End of paragraph is also a space).
				["Cena", "<<cena>>", true, "caseSensitive:true", null, null],
				["<cena> ", "<<cena>>"],
				["<cena_pro>cyjna", "<<cena_pro>>"],
				["Produkty komplementarne:", "<<produkty_kom>>", true, null, null, null],
				["Średnica", "<<srednica>>"],
				["Wymiary", "<<wymiary>>"],
				["Rozmiar", "<<rozmiar>>"],
				["szt.", "<<szt>>"],
				["MAKSYMALNA DŁUGOŚĆ CIĘCIA", "<<max_dl_ciecia>>"],
				["Długość", "<<dlugosc>>"],
				["Szerokość", "<<szer>>"],
				["komplet", "<<komplet>>"],
				["Mocowanie", "<<mocowanie>>"],
				["Moc", "<<moc>>", true, "caseSensitive:true", null, null],
				["Udźwig", "<<udzwig>>"],
				["opakowanie", "<<opak>>"],
				["Zęby", "<<zeby>>"],
				["Otwór", "<<otwor>>"],
				["Urządzenie", "<<urzad>>"],
				["Waga", "<<waga>>"],
				["ilość", "<<ilosc>>"],
				["Pojemność", "<<pojemnosc>>"],
				["rozstaw", "<<rozstaw>>"],
				["żółty", "<<zolty>>"],
				["czerwony", "<<czerwony>>"],
				["niebieski", "<<niebieski>>"],
				["biały", "<<bialy>>"],
				["pomarańczowy", "<<pomaranczowy>>"],
				["czarny", "<<czarny>>"],
				["złoty", "<<zloty>>"],
				["srebrny", "<<srebrny>>"],
				["przezroczysty", "<<przezroczysty>>"],
				["zielony", "<<zielony>>"],
				["różowy", "<<rozowy>>"],
				["mleczny", "<<mleczny>>"],
				["miodowy", "<<miodowy>>"],
				["Parametry", "<<parametry>>"],
				["Kolor", "<<kolor>>"],
				["Gradacja", "<<gradacja>>"],
				["Poliester", "<<poliester>>"],
				["Bawełna", "<<bawelna>>"],
				["Gramatura", "<<gramatura>>"],
				["Oferta specjalna", "<<oferta_s>>"],
				["Podano stałe ceny netto. Od powyższych cen nie obowiązują rabaty indywidualne.", "<<podano_stale>>"],
				["styczeń", "<<sty>>"],
				["luty", "<<lut>>"],
				["marzec", "<<mar>>"],
				["kwiecień", "<<kwi>>"],
				["maj", "<<maj>>"],
				["czerwca", "<<cze>>"],
				["lipiec", "<<lip>>"],
				["sierpień", "<<sie>>"],
				["wrzesień", "<<wrz>>"],
				["październik", "<<paz>>"],
				["listopad", "<<lis>>"],
				["grudzień", "<<gru>>"],
				["zawieszka", "<<zawieszka>>"] // NO COMMA AFTER THE LAST ELEMENT
			];
			
		//======================================================================================
		// Progress bar
		var progressWin = new Window("window", scriptName);
		var progressBar = progressWin.add("progressbar", undefined, 0, a.length);
		progressBar.preferredSize.width = 300;
		var progressTxt = progressWin.add("statictext", undefined,  "");
		progressTxt.alignment = "fill";
		progressWin.show();
		//======================================================================================
		
		for (var i = 0; i < a.length; i++) {
			el = a[i];

			if (el.length == 2 || (el.length >2 && el[2])) { // TEXT
				app.findTextPreferences = app.changeTextPreferences = NothingEnum.NOTHING;
				app.findTextPreferences.findWhat = el[0];
				app.changeTextPreferences.changeTo = el[1];
				
				if (el.length == 6) {
					if (el[3] != null) eval("app.findChangeTextOptions.properties = {" + el[3] + "}");
					if (el[4] != null) eval("app.findTextPreferences.properties = {" + el[4] + "}");
					if (el[5] != null) eval("app.changeTextPreferences.properties = {" + el[5] + "}");
				}
				else { // some default values go here
					app.findChangeTextOptions.caseSensitive = true;
					app.findChangeTextOptions.wholeWord = true;
				}
			
				changed = doc.changeText();
				app.findTextPreferences = app.changeTextPreferences = NothingEnum.NOTHING;
			}
			else { // GREP
				app.findGrepPreferences = app.changeGrepPreferences = NothingEnum.NOTHING;
				app.findGrepPreferences.findWhat = el[0];
				app.changeGrepPreferences.changeTo = el[1];
				
				if (el.length == 6) {
					if (el[3] != null) eval("app.findChangeGrepOptions.properties = {" + el[3] + "}");
					if (el[4] != null) eval("app.findGrepPreferences.properties = {" + el[4] + "}");
					if (el[5] != null) eval("app.changeGrepPreferences.properties = {" + el[5] + "}");
				}
				else { // some default values go here
					//if (debugMode) $.writeln("GREP - some default values go here");
				}
			
				changed = doc.changeGrep();
				app.findGrepPreferences = app.changeGrepPreferences = NothingEnum.NOTHING;
			}
			
			count += changed.length;
			if (debugMode && changed.length > 0) $.writeln(el[0] + " → " + el[1] + " — changed: " + changed.length);
			if (changed.length > 0) logArr.push(el[0] + " → " + el[1] + " — changed: " + changed.length);
			progressTxt.text = el[0] + " → " + el[1];
			progressBar.value += 1;
		} // End for
		
		progressWin.close();
		var endTime = new Date();
		var duration = GetDuration(startTime, endTime);
		var report = "Changed " + count + " item" + ((count == 1) ? "" : "s") + ".\n(time elapsed: " + duration + ")";
		logArr.push("\r-------------------------------------------\r" + report);
		var logStr = logArr.join("\r");
		WriteToFile(logStr);
		
		if (debugMode) {
			$.writeln("\r=======================\r" + report);
		}
		else {
			alert(report, scriptName);
		}
	}
	catch(err) {
		if (debugMode) $.writeln(err.message + ", line: " + err.line);
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function PreCheck() {
	if (app.documents.length == 0) ErrorExit("Please open a document and try again.", true);
	doc = app.activeDocument;
	if (doc.converted) ErrorExit("The current document has been modified by being converted from older version of InDesign. Please save the document and try again.", true);
	if (!doc.saved) ErrorExit("The current document has not been saved since it was created. Please save the document and try again.", true);
	Main();
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function GetDate() {
	var date = new Date();
	if ((date.getYear() - 100) < 10) {
		var year = "0" + new String((date.getYear() - 100));
	}
	else {
		var year = new String((date.getYear() - 100));
	}
	var dateString = (date.getMonth() + 1) + "/" + date.getDate() + "/" + year + " " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
	return dateString;
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function GetDuration(startTime, endTime) {
	var str;
	var duration = (endTime - startTime)/1000;
	duration = Math.round(duration);
	if (duration >= 60) {
		var minutes = Math.floor(duration/60);
		var seconds = duration - (minutes * 60);
		str = minutes + ((minutes != 1) ? " minutes, " :  " minute, ") + seconds + ((seconds != 1) ? " seconds" : " second");
		if (minutes >= 60) {
			var hours = Math.floor(minutes/60);
			minutes = minutes - (hours * 60);
			str = hours + ((hours != 1) ? " hours, " : " hour, ") + minutes + ((minutes != 1) ? " minutes, " :  " minute, ") + seconds + ((seconds != 1) ? " seconds" : " second");
		}
	}
	else {
		str = duration + ((duration != 1) ? " seconds" : " second");
	}

	return str;
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function WriteToFile(text) {
	var file = new File("~/Desktop/" + scriptName + ".txt");
	file.encoding = "UTF-8";
	if (file.exists) {
		file.open("e");
		file.seek(0, 2);
	}
	else {
		file.open("w");
	}
	file.write(text + "\r"); 
	file.close();
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function ErrorExit(error, icon) {
	alert(error, scriptName, icon);
	exit();
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------